@echo off

echo.
echo Generating data for PC Week Database Benchmark...
echo.
echo Generating comma-delimited data files.
echo.
echo Current date and time:
date /t
time /t

:START
echo.
echo.
echo '===================================================
echo Set up file location variables and initial directory
echo '===================================================
echo.
echo.

echo 1. Check command line parameter
if "%1" == "44mb" goto PARAM_CONTINUE
if "%1" == "44MB" goto PARAM_CONTINUE
if "%1" == "4.4gb" goto PARAM_CONTINUE
if "%1" == "4.4GB" goto PARAM_CONTINUE
goto NO_PARAM_ERROR
:PARAM_CONTINUE

echo 2. Set environment variables and check file locations
set PCW_DBDATAGEN_HOME_DRIVE=C:
set PCW_DBDATAGEN_HOME_DIRECTORY=C:\A - Generate Data
set PCW_IMPORT_DATA_DRIVE=D:
set PCW_IMPORT_DATA_DIRECTORY=D:\Data

if not exist "%PCW_DBDATAGEN_HOME_DIRECTORY%\dbdatagen.bat" goto FILES_MISSING_ERROR
if not exist "%PCW_DBDATAGEN_HOME_DIRECTORY%\as3apgen.exe" goto FILES_MISSING_ERROR
if not exist "%PCW_DBDATAGEN_HOME_DIRECTORY%\a1-create_dataset_%1.bat" goto FILES_MISSING_ERROR
if not exist "%PCW_IMPORT_DATA_DIRECTORY%" goto FILES_MISSING_ERROR

%PCW_DBDATAGEN_HOME_DRIVE%
cd %PCW_DBDATAGEN_HOME_DIRECTORY%

:GEN_DATA
echo.
echo.
echo '=========================================
echo A. Generate Data
echo '=========================================
echo.
echo.

echo Press any key to start generating the data set. Generated data files
echo will be placed in %PCW_IMPORT_DATA_DIRECTORY%.
echo.
pause
echo.

if exist *-output.txt del *-output.txt

echo 1. Generate benchmark dataset

rem copy data generator files
copy as3apgen.exe "%PCW_IMPORT_DATA_DIRECTORY%" > nul
copy a1-create_dataset_%1.bat "%PCW_IMPORT_DATA_DIRECTORY%" > nul
%PCW_IMPORT_DATA_DRIVE%
cd %PCW_IMPORT_DATA_DIRECTORY%

rem Generate the data
call a1-create_dataset_%1.bat

rem clean up files
del as3apgen.exe
del a1-create_dataset_%1.bat
if exist *.txt move *.txt "%PCW_DBDATAGEN_HOME_DIRECTORY%" > nul

%PCW_DBDATAGEN_HOME_DRIVE%
cd "%PCW_DBDATAGEN_HOME_DIRECTORY%"

echo.
echo Ready to run database creation scripts.

goto END

rem =========================================
rem Error handling
rem =========================================

:FILES_MISSING_ERROR
echo.
echo === ERROR ===
echo.
echo The data creation files are not located in %PCW_DBDATAGEN_HOME_DIRECTORY% or
echo the data file output directory %PCW_IMPORT_DATA_DIRECTORY% does not exist.
echo.
echo Please fix these problems and run this file again.
echo.
goto END

:NO_PARAM_ERROR
echo.
echo === ERROR ===
echo.
echo Please run this file with a "44MB" or "4.4GB" parameter to indicate the size
echo of the data file to build.
echo.
echo The 4.4GB version of the data set is 4.43 GB of total data and is the version
echo normally used for benchmarking. It is sized to a machine with 512KB of RAM.
echo.
echo The 44MB MB version of the data set is 44.4 MB of total data and is
echo used to test workgroup or desktop database systems. 
echo.
echo For example,
echo   dbdatagen 44MB
echo or
echo   dbdatagen 4.4GB
echo.
echo Please run this file again with one of these two parameters.
echo.
goto END

:END
echo.
echo Current date and time:
date /t
time /t
echo.
echo Data generation completed.
